/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.FrustumIntersection;

@Environment(value=EnvType.CLIENT)
public class EntityVisibilityTester {
    private final class_1297 entity;
    private final class_2382 renderOrigin;
    private final float scale;
    @Nullable
    private class_238 lastVisibleAABB;

    public EntityVisibilityTester(class_1297 entity, class_2382 renderOrigin, float scale) {
        this.entity = entity;
        this.renderOrigin = renderOrigin;
        this.scale = scale;
    }

    public boolean check(FrustumIntersection frustum) {
        boolean visible;
        class_238 aabb = class_310.method_1551().method_1561().method_3953(this.entity).method_62358(this.entity);
        boolean bl = visible = this.lastVisibleAABB == null;
        if (!visible) {
            visible = this.adjustAndTestAABB(frustum, aabb);
        }
        if (!visible && this.lastVisibleAABB != aabb) {
            visible = this.adjustAndTestAABB(frustum, this.lastVisibleAABB);
        }
        if (visible) {
            this.lastVisibleAABB = aabb;
        }
        return visible;
    }

    private boolean adjustAndTestAABB(FrustumIntersection frustum, class_238 aabb) {
        float x = (float)class_3532.method_16436((double)0.5, (double)aabb.field_1323, (double)aabb.field_1320) - (float)this.renderOrigin.method_10263();
        float y = (float)class_3532.method_16436((double)0.5, (double)aabb.field_1322, (double)aabb.field_1325) - (float)this.renderOrigin.method_10264();
        float z = (float)class_3532.method_16436((double)0.5, (double)aabb.field_1321, (double)aabb.field_1324) - (float)this.renderOrigin.method_10260();
        float maxSize = (float)Math.max(aabb.method_17939(), Math.max(aabb.method_17940(), aabb.method_17941()));
        return frustum.testSphere(x, y, z, maxSize * MoreMath.SQRT_3_OVER_2 * this.scale);
    }
}

